import os
import hashlib
import requests
import time
import sys

CLE_API_VT = "VOTRE_API_VIRUSTOTAL"
CLE_API_MB = "VOTRE_API_MALWAREBAZAAR"

def calcul_sha256(fichier):
    hasher = hashlib.sha256()
    with open(fichier, "rb") as f:
        while bloc := f.read(8192):
            hasher.update(bloc)
    return hasher.hexdigest()

def scan_virustotal(hash):
    rep = requests.get(
        f"https://www.virustotal.com/api/v3/files/{hash}",
        headers={"x-apikey": CLE_API_VT}
    )
    if rep.status_code == 200:
        stats = rep.json()["data"]["attributes"]["last_analysis_stats"]
        return f"Detections: {stats['malicious']} malveillant / {stats['harmless']} propre"
    return "Non trouvé"

def scan_malwarebazaar(hash):
    rep = requests.post(
        "https://mb-api.abuse.ch/api/v1/",
        data={"query": "get_info", "hash": hash, "apikey": CLE_API_MB}
    )
    if rep.status_code == 200 and rep.json().get("query_status") == "ok":
        return "Trouvé dans la base"
    return "Non trouvé"

def analyser(dossier):
    for fichier in os.listdir(dossier):
        chemin = os.path.join(dossier, fichier)
        if os.path.isfile(chemin):
            print(f"\nFichier: {fichier}")
            hash = calcul_sha256(chemin)
            print(f"SHA-256: {hash}")
            
            print("VirusTotal:", scan_virustotal(hash))
            print("MalwareBazaar:", scan_malwarebazaar(hash))
            
            time.sleep(15) 

if __name__ == "__main__":
  
    dossier = sys.argv[1]
    if os.path.isdir(dossier):
        analyser(dossier)
    else:
        print("Dossier invalide")